-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("victory")
  self:AddTriggerTarget("defeat")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.victory = false
    self.defeat = false
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      MarkMainGoal(self)
    end
  end
  
  if self.victory then
    self.p0:WinQuest('D9G_GOAL_1')
    self.p0:WinQuest('D9G_GOAL_2')
    Citadels.SetAchievementDone(14)
    Citadels.ForceVictory()
  end
  
  if self.defeat then
    Citadels.ForceDefeat()
  end  
end

function MarkMainGoal(self)
  g1PosX = Game:GetEntity("mainBase"):GetPosition().x
  g1PosY = Game:GetEntity("mainBase"):GetPosition().y
  g2PosX = Game:GetEntity("mountainTown"):GetPosition().x
  g2PosY = Game:GetEntity("mountainTown"):GetPosition().y

  self.p0:AddQuest('D9G_GOAL_1','main')   
  self.p0:SetQuestPosition('D9G_GOAL_1', g1PosX, g1PosY)
  
  self.p0:AddQuest('D9G_GOAL_2','main')
  self.p0:SetQuestPosition('D9G_GOAL_2', g2PosX, g2PosY)
end

function OnTrigger(self, source, target)
  if target == "victory" then
    self.victory = true
  elseif target == "defeat" then
    self.defeat = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
  end
end
